<?php
// Check File Is Included
if(!defined('IncludedFile')) {header("Location:index.php");exit;}
// Get Count Variables
$sql = "SELECT id FROM campaigns";
$rs=$conn->query($sql);
$total_rows = $rs->num_rows;
// Include Header
include("header.php");
// Check If New User With No Campaigns
if($total_rows=="0"){
	echo "<style>.welcome_message{font-weight:bold;font-size:13px;}</style>";
	echo "<script>jQuery.facebox('Welcome To Your Admin Panel ".ucfirst($_SESSION['username'])."<br /><br />Only You Can Securely Access Your Data Via This Panel<br /><br />For More Information Visit The Support Tab', 'welcome_message');</script>";
	}
// Display Tab Content
?>
<!-- 100% Box Grid Container: Start -->
<div class="grid_24">

	<!-- Box Header: Start -->
	<div class="box_top">
		
		<h2 class="icon pages">Campaigns<span class="tip" title="Total Number Of Campaigns"><?php echo $total_rows; ?></span></h2>
		
		<!-- Tab Select: Start -->
		<ul class="sorting">
			<li><a href="#campaigns_tab" class="active" id="campaigns_list_tab_link">Campaigns List</a></li>
			<li><a href="#addcampaign">Add New Campaign</a></li>
		</ul>
		<!-- Tab Select: End -->
		
	</div>
	<!-- Box Header: End -->
	
	<!-- Box Content: Start -->
	<div class="box_content">
		
		<!-- Campaigns Table Tabs: Start -->
		<div class="tabs">
		
			<!-- Campaigns Sorting Table: Start -->
			<div id="campaigns_tab">
				<table class="sorting" name="campaigns_list">
					<thead>
						<tr>
							<th class="checkers"><input type="checkbox" class="checkall" /></th>
							<th class="align_left">Campaign Name</th>
							<th class="align_left center">Referrer Type</th>
							<th class="align_left center">Daily Hits</th>
							<th class="align_left center">Total Hits</th>
							<th class="align_left center">Latest Hit</th>
							<th class="align_left center tools">Tools</th>
						</tr>
					</thead>
					<tbody>
                    	
                        <?php
						$sql = "SELECT * FROM campaigns ORDER BY id DESC";
						$rs=$conn->query($sql);
						while($row = $rs->fetch_assoc()){
							// Fetch Campaign Data
							$latest_hit_timestamp = $row['latest_hit'];
							if($latest_hit_timestamp=="0"){
								$latest_hit_str = "Never";
							}else{
								$latest_hit_str = adminmkdate($latest_hit_timestamp);
								// Calculate Time Difference
								$latest_hit_datetime = new DateTime();
								$latest_hit_datetime->setTimestamp($latest_hit_timestamp);
								$now = new DateTime();
								$time_differnce = $now->diff($latest_hit_datetime, true);
								// Set Friendly Text
								if($time_differnce->s!="0"){if($time_differnce->s>1){$latest_hit_str = $time_differnce->s." Seconds Ago";}else{$latest_hit_str = $time_differnce->s." Second Ago";}}
								if($time_differnce->i!="0"){if($time_differnce->i>1){$latest_hit_str = $time_differnce->i." Minutes Ago";}else{$latest_hit_str = $time_differnce->i." Minute Ago";}}
								if($time_differnce->h!="0"){if($time_differnce->h>1){$latest_hit_str = $time_differnce->h." Hours Ago";}else{$latest_hit_str = $time_differnce->h." Hour Ago";}}
								if($time_differnce->d!="0"){if($time_differnce->d>1){$latest_hit_str = $time_differnce->d." Days Ago";}else{$latest_hit_str = $time_differnce->d." Day Ago";}}
								if($time_differnce->m!="0"){if($time_differnce->m>1){$latest_hit_str = $time_differnce->m." Months Ago";}else{$latest_hit_str = $time_differnce->m." Month Ago";}}
								if($time_differnce->y!="0"){if($time_differnce->y>1){$latest_hit_str = $time_differnce->y." Years Ago";}else{$latest_hit_str = $time_differnce->y." Year Ago";}}
								}
							// Count Daily Hits (Last 24 Hours)
							$yesterday = time() - (24*60*60);
							// $sql = "SELECT id FROM logs WHERE campaignid='".$row['id']."' AND time_stamp>".$yesterday;
							$result = $conn->query("SELECT id FROM logs WHERE campaignid='".$row['id']."' AND time_stamp>".$yesterday);
							$daily_hits = $result->num_rows;
							// $rs=$conn->query($sql);
							// $daily_hits = $rs->num_rows;
							// Display Row
							echo '
							<tr id="campaign_'.$row['id'].'">
								<th class="checkers"><input type="checkbox" value="'.$row['id'].'" /></th>
								<td class="align_left"><a href="#" camp_url="'.$folder_url.$row['linktag'].'" id="get_link_code_click">'.$row['name'].'</a></td>
								<td class="align_left center"><a href="#ref_types" class="popup">'.GetReferrerType($row['reftype'], $row['id']).'</a></td>
								<td class="align_left center">'.$daily_hits.'</td>
								<td class="align_left center">'.$row['hits'].'</td>
								<td class="align_left center"><span style="display:none">'.$latest_hit_timestamp.'</span>'.$latest_hit_str.'</td>
								<td class="align_left tools center">
									<a href="#editcampaign" campid="'.$row['id'].'" class="edit tip" title="edit" id="edit_campaign_click">edit</a>
									<a href="#" camp_url="'.$folder_url.$row['linktag'].'" fake_ref="'.$row['fakeref'].'" link_tag="'.$row['linktag'].'" destination_url="'.$row['url'].'" class="view tip" title="get link code" id="get_link_code_click">view</a>
									<a href="#" class="delete tip" title="delete" id="delete_campaign">delete</a>
								</td>
							</tr>';
							}
						?>
						
					</tbody>
				</table> 
				                
				<!-- Campaigns Sorting Table Actions: Start -->
				<div class="table_actions">
					<input type="checkbox" class="checkall" />
					
					<select id="campaign_manager_selector">
						<option>Choose action</option>
						<option>Clear Stats</option>
						<option>Delete Campaign(s)</option>
					</select>
					
					<button id="campaign_manager_button" class="left">Apply to Selected</button>
				</div>
				<!-- Campaigns Sorting Table Actions: End -->
				
			</div>
			<!-- Campaigns Sorting Table: End -->
			
            <!-- Campaigns Sorting Table - Add Campaign Tab: Start -->
            <div id="addcampaign" class="padding">
            
                <!-- Create New Campaign Form: Start -->
                <form action="" method="post" id="create_campaign">
                
                <p class="note" id="main_message">
                    <span class="icon info"></span> 
                    Enter the information below to create a new link campaign
                </p>
                    
                <div class="field">
                    <label for="name" class="left">Campaign Name</label>
                    <input type="text" class="left validate" name="name" id="campaign_name_input">
                    <p class="info left small nomargin" id="name-field">
                        <span class="icon info"></span> 
                        For Your Reference Only
                    </p>
                </div>
    
                <div class="field">
                    <label class="left nomargin">Referrer Type:</label>
                    <select name="reftype" id="reftype_selector">
                        <option value="0">Direct Link</option>
                        <option value="1">Blank Referrer</option>
                        <option value="2">Fake Referrer</option>
                        <option value="3">Google Referrer</option>
                        <option value="4">Twitter Referrer</option>
                        <option value="5">StumbleUpon Referrer</option>
                        <!-- <option value="6">URL.com Referrer</option> -->
                        <option value="7">Portal Page</option>
                        <option value="9">DuckDuckGo.com Referrer</option>
                    </select>
                </div>
                                  
                <div class="field">
                    <label class="left">Destination URL</label>
                    <input type="text" class="left validate" name="url" id="campaign_url_input">
                    <p class="info left small nomargin" id="url-field">
                        <span class="icon info"></span> 
                        This Is Where You Want To Send Your Visitors To
                    </p>
                </div>
                    
                <div class="field">
                    <label class="left">Link Tag</label>
                    <input type="text" class="left validate" domain="<?php echo $folder_url; ?>" name="linktag" id="campaign_linktag_input">
                    <p class="info left small nomargin" id="linktag-field">
                        <span class="icon info"></span> 
                        Campaign URL: <?php echo $folder_url; ?>LinkTag
                    </p>
                </div>
                    
                <div class="field" style="display:none;" id="fakeref_field_display">
                    <label class="left">Fake Referrer URL</label>
                    <input type="text" class="left validate" name="fakeref" id="campaign_fakeref_input">
                    <p class="info left small nomargin" id="fakeref-field">
                        <span class="icon info"></span> 
                        You Must Be Able To Add PHP Code To This URL
                    </p>
                </div>
                
                <div class="field" style="display:none;" id="google_keywords_field_display">
                    <label class="left">Google Keywords</label>
                    <input type="text" class="left" name="google_keywords" id="campaign_google_keywords_input">
                    <p class="info left small nomargin" id="google_keywords-field">
                        <span class="icon info"></span> 
                        These Will Appear As The Search Keywords From Google
                    </p>
                </div>
                    
                <div class="field" style="display:none;" id="google_tld_field_display">
                    <label class="left">Google TLD</label>
                    <input type="text" class="left validate" name="google_tld" value=".com" id="campaign_google_tld_input">
                    <p class="info left small nomargin" id="google_tld-field">
                        <span class="icon info"></span> 
                        This Is The Google Country That Will Be Shown As The Referrer
                    </p>
                </div>
                
                <div class="field" id="campaign_notes_div">
					<label class="left nomargin">Campaign Notes:</label>
               		<textarea style="width:100%" name="notes" id="notes" placeholder="For your reference only"></textarea>
                </div>
                    
              <button id="create_campaign_button" type="submit">Create Campaign</button>
              <button id="reset_fields" class="secondary" type="reset">Reset Form Fields</button>
              
              </form>
              
              <div class="field" style="display:none;" id="create_campaign_loading"></div>
              
			</div>
            <!-- Create New Campaign Form: End -->
            
             <!-- Campaigns Sorting Table - Edit Campaign Tab: Start -->
            <div id="editcampaign" class="padding hide">
            
                <!-- Edit Campaign Form: Start -->
                <form action="" method="post" id="edit_campaign">
                
                <input type="hidden" name="edit_camp_id" id="edit_camp_id" />
                <input type="hidden" name="edit_camp_name" id="edit_camp_name" />
                
                <p class="note" id="edit_main_message">
                    <span class="icon info"></span> 
                    Editing Campaign: XXXX
                </p>
                
                <div class="field">
                    <label for="name" class="left">Campaign Name</label>
                    <input type="text" class="left validate" name="edit_name" id="edit_campaign_name_input">
                    <p class="info left small nomargin" id="edit_name-field">
                        <span class="icon info"></span> 
                        For Your Reference Only
                    </p>
                </div>
    
                <div class="field">
                    <label class="left nomargin">Referrer Type:</label>
                    <select name="edit_reftype" id="edit_reftype_selector">
                        <option value="0">Direct Link</option>
                        <option value="1">Blank Referrer</option>
                        <option value="2">Fake Referrer</option>
                        <option value="3">Google Referrer</option>
                        <option value="4">Twitter Referrer</option>
                        <option value="5">StumbleUpon Referrer</option>
                        <!-- <option value="6">URL.com Referrer</option> -->
                        <option value="7">Portal Page</option>
                        <option value="9">DuckDuckGo.com Referrer</option>
                    </select>
                </div>
                                  
                <div class="field">
                    <label class="left">Destination URL</label>
                    <input type="text" class="left validate" name="edit_url" id="edit_campaign_url_input">
                    <p class="info left small nomargin" id="edit_url-field">
                        <span class="icon info"></span> 
                        This Is Where You Want To Send Your Visitors To
                    </p>
                </div>
                    
                <div class="field">
                    <label class="left">Link Tag</label>
                    <input type="text" class="left validate" domain="<?php echo $folder_url; ?>" name="edit_linktag" id="edit_campaign_linktag_input">
                    <p class="info left small nomargin" id="edit_linktag-field">
                        <span class="icon info"></span> 
                        Campaign URL: <?php echo $folder_url; ?>LinkTag
                    </p>
                </div>
                    
                <div class="field" style="display:none;" id="edit_fakeref_field_display">
                    <label class="left">Fake Referrer URL</label>
                    <input type="text" class="left validate" name="edit_fakeref" id="edit_campaign_fakeref_input">
                    <p class="info left small nomargin" id="edit_fakeref-field">
                        <span class="icon info"></span> 
                        You Must Be Able To Add PHP Code To This URL
                    </p>
                </div>
                
                <div class="field" style="display:none;" id="edit_google_keywords_field_display">
                    <label class="left">Google Keywords</label>
                    <input type="text" class="left" name="edit_google_keywords" id="edit_campaign_google_keywords_input">
                    <p class="info left small nomargin" id="edit_google_keywords-field">
                        <span class="icon info"></span> 
                        These Will Appear As The Search Keywords From Google
                    </p>
                </div>
                    
                <div class="field" style="display:none;" id="edit_google_tld_field_display">
                    <label class="left">Google TLD</label>
                    <input type="text" class="left validate" name="edit_google_tld" value=".com" id="edit_campaign_google_tld_input">
                    <p class="info left small nomargin" id="edit_google_tld-field">
                        <span class="icon info"></span> 
                        This Is The Google Country That Will Be Shown As The Referrer
                    </p>
                </div>
                
                <div class="field" id="edit_campaign_notes_div">
					<label class="left nomargin">Campaign Notes:</label>
               		<textarea style="width:100%" name="edit_notes" id="edit_notes" placeholder="For your reference only"></textarea>
                </div>
                                   
              <button id="edit_campaign_button" type="submit">Edit Campaign</button>
              
              </form>
              
              <div class="field" style="display:none;" id="edit_campaign_loading"></div>
                
			</div>
            <!-- Edit Campaign Form: End -->
            
            
		</div>
		<!-- Campaigns Table Tabs: End -->
        
        <!-- RefTypes Popup Content: Start -->
		<div class="box_content padding hide" id="ref_types">
			<h6>Referrer Types</h6>
            
            <p>Direct Link: This option does not affect the referring URL. It will simply track your traffic for you &amp; reveal the true referring URL to your destination URL.</p>
            
            <p>Blank Referrer: This option will completely remove the referring URL so it will look like the user has typed your destination URL into their browser or come from an email client.</p>
            
            <p>Fake Referrer: This option allows you to fake the referring URL to a URL that you can add PHP code to, so any page on a website that you own.</p>
            
            <p>Google Referrer: This option sets the referring URL as Google search traffic. You can also add keywords searched &amp; set the Google country that the user came from.</p>
            
            <p>Twitter Referrer: This will send a t.co referrer to make your destination URL see your traffic is coming from Twitter.</p>
            
            <p>StumbleUpon Referrer: This will send your users through StumbleUpon with their framed page content so it seems as if your visitors are coming from StumbleUpon while browsing.</p>
            
            <!-- <p>URL.com Referrer: This is a search engine &amp; your destination URL will see that your visitors are coming from this search engine.</p> -->
            
            <p>Portal Page: This will show your destination URL that your visitors are coming from your <?php echo $product_name; ?> installation URL. You can set this content under the Settings tab.</p>
            
            <p>DuckDuckGo.com Referrer: This is a search engine &amp; your destination URL will see that your visitors are coming from this search engine.</p>
		
		</div>
		<!-- RefTypes Popup Content: End -->

	</div>
	<!-- Box Content: End -->
	
</div>
<!-- 100% Box Grid Container: End -->

<?php
// Include Footer
include("footer.php");
?>