<!DOCTYPE HTML>

<head>

	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<?php echo '<title>BlackHatToolz.com - '.$product_name.' '.$product_version.'</title>'; ?>
	
	<!-- Imports General CSS and jQuery CSS -->
	<link href="css/screen.css" rel="stylesheet" media="screen" type="text/css" />
    
    <link rel="icon" type="image/x-icon" href="img/favicon.ico" />
	
	<!-- CSS for Fluid and Fixed Widths - Double to prevent flickering on change -->
	<link href="css/fixed.css" rel="stylesheet" media="screen" type="text/css" />
	<link href="css/fixed.css" rel="stylesheet" media="screen" type="text/css" class="width" />
	
	<!-- IE Stylesheet ie7 - Added in 1.2 -->
	<!--[if lt IE 8]> <html lang="en" class="ie7"> <![endif]-->
	
	<!-- IE Stylesheet ie8 - Added in 1.1 -->
	<!--[if IE 8 ]> <html lang="en" class="ie8"> <![endif]-->
	
	<!-- CSS for Theme Styles - Double to prevent flickering on change -->
	<link href="css/theme/brown.css" rel="stylesheet" media="screen" type="text/css" />
	<link href="css/theme/brown.css" rel="stylesheet" media="screen" type="text/css" class="theme" />
	
	<!-- IE Canvas Fix for Visualize Charts - Added in 1.1 -->
	<!--[if IE]><script type="text/javascript" src="js/excanvas.js"></script><![endif]-->
	
	<!-- jQuery thats loaded before document ready to prevent flickering - Rest are found at the bottom -->
	<script type="text/javascript" src="js/jquery-1.4.1.min.js"></script>
	<script type="text/javascript" src="js/jquery.cookie.js"></script>
	<script type="text/javascript" src="js/jquery.styleswitcher.js"></script>
	<script type="text/javascript" src="js/jquery.visualize.js"></script>
    
     <!-- load jQuery 2.0.3 -->
	<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/2.0.3/jquery.min.js"></script>
    <script type="text/javascript">
    var jQuery_2_0_3 = $.noConflict(true);
    </script>
	
</head>

<body>

<!-- Start: Page Wrap -->
<div id="wrap" class="container_24">


<!-- Grid Container: Start (centers) -->
	<div class="login2">

		<!-- 100% Box Grid Container: Start -->
		<div class="grid_12">
		
			<!-- Box Header: Start -->
			<div class="box_top">
				
				<h2 class="icon key">Login</h2>
				
				<!-- Tab Select: Start -->
				<ul class="sorting">
					<li><a href="#login" class="active">Login</a></li>
					<li><a href="#install">Install</a></li>
					<li><a href="#forgot">Forgot Password</a></li>
				</ul>
				<!-- Tab Select: End -->
				
			</div>
			<!-- Box Header: End -->
            
            
            		
			<!-- Box Content: Start -->
			<div class="box_content padding">
            
                <!-- Error Notice: Start -->
                <div id="login_error" class="notice error hide"></div>
                <!-- Error Notice: End -->
				
				<!-- Tabs: Start -->
				<div class="tabs">
					<!-- Login Tab: Start -->
					<div id="login">
                    
						<?php 
                        // Check If Install Required
                        if($install_required==1){
                            ?>
                            <div class="notice error">
                                <p><b>Installation Required - Click Install Above<?php if($db_error!=''){echo "<br />".$db_error;} ?></b></p>
                            </div>
                            <?php
							if((isset($dbname))||(isset($dbname)!="")){
								?>
                                <div class="field noline right nopadding">
                                    <a href="#db_error" class="popup" >Already Installed <?php echo $product_name; ?>? </a>
                                </div>
                                <?php
								}
								?>
                            <?php
                        }else{
							?>
                            <p id="login_note" class="note small">Welcome to <?php echo $product_name; ?>, to login enter your BHT login information below &amp; then click <b>login</b>.</p>
						
                            <form id="login_form" method="post">
                                
                                <input type="hidden" name="login" value="1" />
                            
                                <div class="field noline nopadding">
                                    <label class="left" for="username">Username</label>
                                    <input type="text" class="validate tip-stay right" title="Enter Your username" name="username">
                                </div>
                                
                                <div class="field">
                                    <label class="left" for="password">Password</label>
                                    <input type="password" class="validate tip-stay right" title="Enter Your password" name="password">
                                </div>
                                
                                <div class="field noline nopadding">
                                    
                                    <div class="right">
                                        <button type="submit">Login</button>
                                    </div>
                                </div>
                            
                            </form>
                            <?php
							}
                        ?>
						
						
					</div>
					<!-- Login Tab: End -->
					
					<!-- Install Tab: Start -->
					<div id="install">
                    
                    	<?php
						// Check If Install Required
                        if($install_required==0){
							?>
                            <div class="notice error">
                                <p><b><?php echo $product_name; ?> Has Already Been Installed</b></p>
                            </div>
                            <?php
						}else{
							?>
                            <!-- Error Notice: Start -->
							<div id="install_error" class="notice error hide"></div>
                            <!-- Error Notice: End -->
                            <p id="install_note" class="note small">Enter your account information below to install <?php echo $product_name; ?> </p>
						
                            <form id="install_form" method="post">
                                
                                <div class="field noline nopadding">
                                    <label class="left" for="username">BHT Username</label>
                                    <input type="text" class="validate tip-stay right" title="Enter Your Prefered Username" id="username" name="username" value="">
                                </div>

                                <div class="field noline nopadding">
                                    <label class="left" for="password">BHT Password</label>
                                    <input type="text" class="validate tip-stay right" title="Enter The Password You Want" id="password" name="password">
                                </div>
                                
                                <div class="field noline nopadding">
                                    <label class="left" for="db_name">Database Name</label>
                                    <input type="text" class="validate tip-stay right" title="Enter Database Name" id="db_name" name="db_name" value="">
                                </div>
                                
                                <div class="field noline nopadding">
                                    <label class="left" for="db_username">Database Username</label>
                                    <input type="text" class="validate tip-stay right" title="Enter Database Username" id="db_username" name="db_username" value="">
                                </div>
                                
                                <div class="field noline nopadding">
                                    <label class="left" for="db_password">Database Password</label>
                                    <input type="text" class="validate tip-stay right" title="Enter Database Password" id="db_password" name="db_password" value="">
                                </div>
        
                                <div class="field noline right nopadding">
                                
                                    <a href="#help" class="popup">Require help installing <?php echo $product_name; ?>? </a>
                                    <button type="submit">Install</button>
                                </div>
                            
                            </form>
                        <?php
							}
						?>
							
					</div>
					<!-- Install Tab: End -->
					
					<!-- Forgot Password Tab: Start -->
					<div id="forgot">
                    	<!-- Error Notice: Start -->
						<div id="forgot_error" class="notice error hide"></div>
                        <!-- Error Notice: End -->
						<p id="forgot_note" class="note small">Click The Button Below To Reset Your BHT Password</p>
						
						<form id="forgot_password" method="post">

							
							<div class="field noline right nopadding">
								<button id="reset_password">Send new password</button>
							</div>
                            					
						</form>
						
					</div>
					<!-- Forgot Password Tab: End -->
					
				</div>
				<!-- Tabs: End -->
		
			</div>
			<!-- Box Content: End -->
			
		</div>
		<!-- 100% Box Grid Container: End -->


		<!-- Help Popup Content: Start -->
		<div class="box_content padding hide" id="help">
			<h6>Help Installing <?php echo $product_name; ?></h6>
		
			<p>Welcome to our <?php echo $product_name; ?>.</p>
            
            <p>The instructions below show how you can install <?php echo $product_name; ?>. If you require additional help please email us at <a href="mailto:<?php echo $support_email; ?>"><?php echo $support_email; ?></a>. Make sure to include your cPanel login information &amp; the URL to this page so that we can manage this process for you.</p>
		
			<p>Step 1) Login to cPanel on your server &amp; click MySQL Databases.</p>
            
            <p>Step 2) Under 'Create New Database' enter a database name for <?php echo $product_name; ?> to be installed to, E.g. 'links' &amp; then click 'Create Database'.</p>
            
            <p>Step 3) Click 'Go Back' &amp; you will be back on the MySQL Databases page.</p>
            
            <p>Step 4) Under 'Add New User' enter a database username, E.g. 'links' &amp; then click 'Create User'.</p>
            
            <p>Step 5) Click 'Go Back' &amp; you will be back on the MySQL Databases page.</p>
            
            <p>Step 6) Under 'Add User To Database' select your newly created username &amp; database from the drop down lists &amp; then click 'Add'.</p>
            
            <p>Step 7) On the next page click the 'ALL PRIVILEGES' checkbox &amp; then click 'Make Changes'.</p>
		
			<p>Step 8) Enter this database information &amp; your preferred login information along with your license key onto the <?php echo $product_name; ?> install page.</p>
            
            <p>Note: You can find your license key here: </p>
		
		</div>
		<!-- Help Popup Content: End -->
        
        <!-- DB Error Popup Content: Start -->
		<div class="box_content padding hide" id="db_error">
			<h6>Already Installed <?php echo $product_name; ?>?</h6>
		
			<p><?php echo $product_name; ?> cannot connect to your database, their is potentially an issue with your database settings.</p>
            
            <?php
			if($db_error!=""){
                echo "<p>The exact error being shown from your database can be seen below:</p>";
				echo "<p>".$db_error."</p>";
			}else{
				echo "<p>The admin settings table is missing from your database.</p>";
				echo "<p>If you have NOT created any campaigns yet then please use the Install tab to re-install ".$product_name.".</p>";
				}
            ?>
            
            
            <p>If you require additional help please email us at <a href="mailto:<?php echo $support_email; ?>"><?php echo $support_email; ?></a>. Make sure to include your cPanel login information &amp; the URL to this page so that we can manage this process for you.</p>
            
		</div>
		<!-- Help Popup Content: End -->
		
	</div>
	<!-- Grid Container: End (centers) -->


</div>
<!-- End: Page Wrap -->

	<!-- jQuery libs - Rest are found in the head section (at top) -->
	<script type="text/javascript" src="js/jquery.visualize-tooltip.js"></script>
	<script type="text/javascript" src="js/jquery-animate-css-rotate-scale.js"></script>
	<script type="text/javascript" src="js/jquery-ui-1.8.13.custom.min.js"></script>
	<script type="text/javascript" src="js/jquery.poshytip.min.js"></script>
	<script type="text/javascript" src="js/jquery.quicksand.js"></script>
	<script type="text/javascript" src="js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="js/jquery.facebox.js"></script>
	<script type="text/javascript" src="js/jquery.uniform.min.js"></script>
	<script type="text/javascript" src="js/jquery.wysiwyg.js"></script>
	<script type="text/javascript" src="js/syntaxHighlighter/shCore.js"></script>
	<script type="text/javascript" src="js/syntaxHighlighter/shBrushXml.js"></script>
	<script type="text/javascript" src="js/syntaxHighlighter/shBrushJScript.js"></script>
	<script type="text/javascript" src="js/syntaxHighlighter/shBrushCss.js"></script>
	<script type="text/javascript" src="js/syntaxHighlighter/shBrushPhp.js"></script>
	<script type="text/javascript" src="js/fileTree/jqueryFileTree.js"></script> <!-- Added in 1.2 -->
	
	<!-- jQuery Customization -->
	<script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js/linkrefer_1003.js"></script>

</body>
</html>