<?php
// Check File Is Included
if(!defined('IncludedFile')) {header("Location:index.php");exit;}
// Include Header
include("header.php");
// Display Tab Content
?>

<!-- 100% Box Grid Container: Start -->
<div class="grid_24">

	<!-- Box Header: Start -->
	<div class="box_top">
		
		<h2 class="icon pages">Script Support / FAQ</h2>
		
		<!-- Tab Select: Start -->
		<ul class="sorting">
			<li><a href="#tab1" class="active">Campaigns</a></li>
			<li><a href="#tab2">Actions Log</a></li>
			<li><a href="#tab3">Settings</a></li>
			<!-- <li><a href="#tab4">Miscellaneous</a></li> -->
            <li><a href="#tab5">FAQ</a></li>
		</ul>
		<!-- Tab Select: End -->
		
	</div>
	<!-- Box Header: End -->
	
	<!-- Box Content: Start -->
	<div class="box_content padding">
		
		<!-- Tabs: Start -->
		<div class="tabs">
			
			<div id="tab1">
			  <p><strong>Campaigns Overview</strong></p>
				<p>You can create an unlimited number of campaigns which are self-contained within that campaign area. Campaigns do not work between each other, unless you were to create a campaign that sends the user to another link generated by LinkRefer.				</p>
				<p><strong>Creating A Campaign: </strong>To create a new campaign click on the Campaigns tab &amp; then click on 'Add New Campaign'.</p>
				<p>&nbsp;</p>
				<p><strong>Campaign Name:</strong> This is for your reference only. It will appear on the campaigns table &amp; also within the actions log. No other users will see this name.</p>
				<p><strong>Referrer Type:</strong> This is what your destination URL will see as the referring URL (where your visitors came from). So if you were sending users from yourwebsite.com to theirwebsite.com you could make theirwebsite.com think that your visitors came from Google, or Twitter, or one of the other supported referrer types.</p>
				<p>Different referrer types have different requirements &amp; actions:			  </p>
				<ul>
				  <li>Direct Link - This will send the user directly to the link without altering the referring URL.</li>
				  <li>Blank Referrer - This will remove the referring URL so that it looks like the user has either entered the URL into their browser, come from a mobile client, or from a secure website with an SSL certificate.</li>
				  <li>Fake Referrer - This option will change the referring URL to another page that you own &amp; that runs with PHP. You must be in control of this URL to add a PHP code snippet to the top of the URL that you enter which will handle this request. For WordPress simply add the generated code snippet to the very top of the header.php file of the active theme using  WP Admin&gt; Appearance &gt; Editor &gt; Click header.php.</li>
				  <li>Google Referrer - This will send the user through Google instantly before sending them to your destination URL. Your destination URL must be indexed within Google for this option to work.</li>
				  <li>Twitter Referrer - With this option the referring URL will appear as 't.co' to the destination URL. You must enter Twitter login information on the Settings tab to use this &amp; the script will automatically post a tweet with your destination URL to create the t.co link automatically.</li>
				  <li>StumbleUpon Referrer - This referrer option requires a <a href="http://blackhattoolz.com/links/2Captcha" target="_blank">2Captcha.com API key</a> to be entered due to a captcha being required during the StumbleUpon login process. When sending users to your generated LinkRefer link with a StumbleUpon referring URL they will be presented with the StumbleUpon frame URL with the thumbs up/down page view.</li>
				  <li>Portal Page Referrer - This option will show a referring URL of <?php echo $folder_url; ?> to your destination URL. You can set the content that is shown on this page via Settings &gt; Script Settings &gt; Whitehat HTML.</li>
				  <li>DuckDuckGo.com Referrer - This option will show a referring URL of http://r.duckduckgo.com/ to your destination URL.</li>
			  </ul>
				<p>Destination URL: This is the URL where your visitor will end up.</p>
				<p>Link Tag: This is what your link will look like, E.g. <?php echo $folder_url; ?>LINKTAG</p>
			  <p>Campaign Notes:	These	are	for your reference only. The content entered here will never be seen by your visitors.</p>
			  <p>&nbsp;</p>
                <p><strong>Editing A Campaign: </strong>To edit a campaign click on edit campaign pencil in the table view on the right hand column.</p>
                <p>When editing a campaign note that if you are using the fake referrer option the script will re-generate a new PHP snippet that you must update on your fake referrer URL for your changes to take effect if editing the campaign link or referrer type to the fake referrer option.</p>
                <p>Once you have finished making any amendments to your campaign click the Edit Campaign button at the bottom of the page to instantly save your changes.		  </p>
		  </div>
            
			
			<div id="tab2">
				<p><strong>Actions Log Overview</strong></p>
                <p>The actions log allows you to overview any actions made by the script. This will record all of your traffic &amp; you can expand each log's  information to view the full log data by clicking the magnifying glass icon in each column:</p>
                <ul>
                  <li>Log ID</li>
                  <li>Campaign Name (Unavailable if campaign has been deleted)</li>
                  <li>IP Address</li>
                  <li>Useragent</li>
                  <li>Referring URL</li>
                  <li>Keyword (If used)</li>
                  <li>Log Time Stamp</li>
                  <li>Action                </li>
              </ul>
                <p>Logs can be individually deleted using the X icon on the row of the campaign, or mass deleted within the Settings &gt; Script Maintenance area.</p>
                <p>Note that removing any log data will reset the daily hits count.</p>
			</div>
			
			<div id="tab3">
				<p><strong>Settings Overview</strong></p>
              <p>You can configure your account logins, script access settings &amp; whitehat page via the Settings tab.</p>
                <p><strong>Account Settings: </strong>In order for this script to be able to create Twitter / StumbleUpon links must enter your account logins. StumbleUpon also require a captcha during the login process so you should add your <a href="http://blackhattoolz.com/links/2Captcha" target="_blank">2Captcha.com API key</a> to allow the script to pass the captcha during the login process.</p>
                <p>When creating Twitter links the script uses the Twitter OAuth API to prevent potential login issues to your Twitter account. In order to use this simply create a Twitter application with any name/description/website URL on this page: <a href="https://apps.twitter.com/" target="_blank">https://apps.twitter.com/</a></p>
                <p>Once created click the Keys &amp; Access Tokens tab &amp; on this page you can find your Consumer Key &amp; Consumer Secret Key that should be entered on the Settings page of LinkRefer.<br>
                Once you have copied these into the script click create my access token on the same page on Twitter &amp; then use the newly generated keys for your access token &amp; access token secret.</p>
                <p>&nbsp;</p>
                <p><strong>Script Settings:</strong> On this sub-setting you can alter the bot detection methods &amp; set your whitehat page HTML.</p>
                <p>Block Bot Traffic - With this option enabled any visitors being detected as bots / spiders will see your whitehat page.</p>
                <p>Log Traffic - With this option enabled you will be able to track your daily hits &amp; view your visitor logs in the Actions Log tab.</p>
                <p>Whitehat HTML - Here you can enter HTML for your whitehat page. Your whitehat page is shown to bots &amp; anyone that visits your script's homepage URL, which is also seen as the referring URL when using the portal page referrer option (<?php echo $folder_url; ?>).</p>
              <p>You can also customise your bot useragents to block by entering a part of the bot's useragent into the box (one per line), E.g. spider. Be careful not to add anything to common, E.g. firefox. As this would block all firefox users.              </p>
              <p>&nbsp;</p>
              <p><strong>Maintenance:</strong> On this sub-setting you can clear your user log data &amp; download any error log files if you are having issues generating any links with the script that can be sent to <a href="mailto:admin@blackhattoolz.com">admin@blackhattoolz.com</a>.</p>
			</div>
			
			<div id="tab4" style="display:none";>
				<p><strong>Miscellaneous</strong></p>
				<p>&nbsp;</p>
			</div>
            
            <div id="tab5">
				<p>
			    <strong>Frequently Asked Questions</strong></p>
				<p>Currently No Questions - Ask A New Question Here - <a href="https://www.blackhattoolz.com/members/showthread.php?1617-LinkRefer-7-Manage-Click-Campaigns-Alter-Referring-URL-s-Monitor-Traffic" target="_blank">https://www.blackhattoolz.com/members/showthread.php?1617-LinkRefer-7-Manage-Click-Campaigns-Alter-Referring-URL-s-Monitor-Traffic</a></p>
			</div>
			
		</div>
		<!-- Tabs: End -->

	</div>
	<!-- Box Content: End -->
	
</div>
<!-- 100% Box Grid Container: End -->
<?php
// Include Footer
include("footer.php");
?>