/*
 * Decompiled with CFR 0.152.
 */
import JUpload.swingVersion.JUpload;
import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Explorer {
    private JList viewList = new JList();
    private JList viewThumbnail;
    private JTable viewDetailed;
    private int mode = 1;
    static final int MODE_LIST = 1;
    static final int MODE_DETAILED = 2;
    static final int MODE_THUMBNAIL = 3;
    private DetailedTableModel detailedTableModel;

    Explorer() {
        this.viewList.setCellRenderer(new SimpleCellRenderer());
        this.viewList.setVisibleRowCount(-1);
        this.viewList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JUpload.getInstance().notifyFileSelectionListeners(e);
            }
        });
        this.viewThumbnail = new JList();
        this.viewThumbnail.setCellRenderer(new ThumbnailCellRenderer());
        this.viewThumbnail.setVisibleRowCount(1);
        this.viewThumbnail.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JUpload.getInstance().notifyFileSelectionListeners(e);
            }
        });
        this.detailedTableModel = new DetailedTableModel();
        this.viewDetailed = new JTable(this.detailedTableModel);
        this.viewDetailed.setShowGrid(false);
        this.viewDetailed.setAutoResizeMode(0);
        this.detailedTableModel.addMouseListenerToHeaderInTable(this.viewDetailed);
        SelectionListener listener = new SelectionListener(this.viewDetailed);
        this.viewDetailed.getSelectionModel().addListSelectionListener(listener);
        this.viewDetailed.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    public DetailedTableModel getTableModel() {
        return this.detailedTableModel;
    }

    protected JList getViewList() {
        return this.viewList;
    }

    protected int getMode() {
        return this.mode;
    }

    public Component getView() {
        switch (this.getMode()) {
            case 1: {
                return this.viewList;
            }
            case 3: {
                return this.viewThumbnail;
            }
            case 2: {
                return this.viewDetailed;
            }
        }
        return null;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getViewList().addMouseListener(mouseListener);
        this.getViewThumbnail().addMouseListener(mouseListener);
        this.getViewDetailed().addMouseListener(mouseListener);
    }

    public JTable getViewDetailed() {
        return this.viewDetailed;
    }

    public void viewList() {
        this.mode = 1;
    }

    public void viewThumbnail() {
        this.mode = 3;
    }

    public void viewDetailed() {
        this.mode = 2;
    }

    public JList getViewThumbnail() {
        return this.viewThumbnail;
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable t_table) {
            this.table = t_table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                JUpload.getInstance().notifyFileSelectionListeners(e);
            } else if (e.getSource() == this.table.getColumnModel().getSelectionModel() && this.table.getColumnSelectionAllowed()) {
                JUpload.getInstance().notifyFileSelectionListeners(e);
            }
            if (e.getValueIsAdjusting()) {
                JUpload.getInstance().notifyFileSelectionListeners(e);
            }
        }
    }
}

