/*
 * Decompiled with CFR 0.152.
 */
package JUpload.gui;

import JUpload.Messages;
import JUpload.utilities.Debug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreview
extends JComponent
implements PropertyChangeListener,
ComponentListener {
    private static final long serialVersionUID = 3546356228038277429L;
    File file = null;
    ImageIcon original = null;
    ImageIcon thumbnail = null;
    private boolean quality;

    public ImagePreview(JFileChooser fc) {
        Debug.println(this, "ImagePreview() created");
        int previewWidth = 300;
        int previewHeight = 300;
        this.setPreferredSize(new Dimension(previewWidth, previewHeight));
        if (null != fc) {
            Debug.println(this, "ImagePreview() adding ImagePreview listener to filechooser");
            fc.addPropertyChangeListener(this);
        }
        fc.addComponentListener(this);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int previewWidth = e.getComponent().getWidth() / 3;
        int previewHeight = e.getComponent().getHeight() / 3;
        this.setPreferredSize(new Dimension(previewWidth, previewHeight));
        this.doLayout();
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void loadImage() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.file == null) {
            return;
        }
        Debug.println(this, "ImagePreview() Loading image file " + this.file);
        this.original = new ImageIcon(this.file.getPath());
        int maxWidth = this.getWidth() - 10;
        int maxHeight = this.getHeight() - 10;
        float newWidth = this.original.getIconWidth();
        float newHeight = this.original.getIconHeight();
        if (newWidth > newHeight) {
            newWidth = maxWidth;
            newHeight = -1.0f;
        } else {
            newWidth = -1.0f;
            newHeight = maxHeight;
        }
        int a_quality = 1;
        if (this.getQuality()) {
            a_quality = 4;
        }
        this.thumbnail = new ImageIcon(this.original.getImage().getScaledInstance((int)newWidth, (int)newHeight, a_quality));
    }

    public boolean getQuality() {
        return this.quality;
    }

    public void setQuality(boolean quality) {
        this.quality = quality;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isEnabled()) {
            return;
        }
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            int fontHeight = g.getFont().getSize();
            Font previewFont = new Font(null, 1, 12);
            y = fontHeight + 5;
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
            int width = this.original.getIconWidth();
            int height = this.original.getIconHeight();
            if (width > 0 && height > 0) {
                String strWidth = String.valueOf(width);
                String strHeight = String.valueOf(height);
                g.setFont(previewFont);
                if (this.file != null) {
                    String strDisplay = Messages.getString("ImagePreview.0") + strWidth + Messages.getString("ImagePreview.1") + strHeight + Messages.getString("ImagePreview.2") + this.file.length();
                    g.setColor(Color.white);
                    g.drawString(strDisplay, 6, fontHeight + 1);
                    g.setColor(Color.black);
                    g.drawString(strDisplay, 5, fontHeight);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        File[] fileList;
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.file = (File)e.getNewValue();
            if (!this.isEnabled()) {
                return;
            }
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
        if (prop.equals("SelectedFilesChangedProperty") && (fileList = (File[])e.getNewValue()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
            }
        }
    }
}

