/*
 * Decompiled with CFR 0.152.
 */
package JUpload.gui;

import JUpload.http.HTTPRequest;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class UploadManager
extends Thread {
    private Vector threadPool = new Vector();
    private boolean runningThread = false;
    private ArrayList threadHistory;

    public UploadManager() {
        this.setPriority(1);
        this.threadHistory = new ArrayList();
    }

    public void addThread(HTTPRequest httprequest) {
        Debug.println(this, "UploadManager() adding thread " + httprequest);
        this.threadPool.add(httprequest);
        Debug.println(this, "UploadManager() thread added. there are " + this.threadPool.size() + " threads.");
    }

    public void run() {
        Debug.println(this, "UploadManager() run()/start()");
        while (true) {
            HTTPRequest element;
            Iterator iter = this.threadPool.iterator();
            while (iter.hasNext()) {
                element = (HTTPRequest)iter.next();
                if (!element.isFinished()) continue;
                this.threadPool.remove(element);
                Debug.println(this, "UploadManager() removing finishes thread...");
                break;
            }
            this.runningThread = false;
            iter = this.threadPool.iterator();
            while (iter.hasNext()) {
                element = (HTTPRequest)iter.next();
                if (!element.isRunning()) continue;
                this.runningThread = true;
            }
            if (this.threadPool.size() > 0) {
                if (!this.runningThread) {
                    Debug.println(this, "UploadManager() no thread is running... starting one");
                    HTTPRequest httpRequest = (HTTPRequest)this.threadPool.firstElement();
                    this.threadHistory.add(httpRequest);
                    Thread.currentThread().setPriority(1);
                    httpRequest.run();
                }
            } else {
                if (JUpload.getInstance().getQueueSelectedFiles().size() > 0) {
                    JUpload.getInstance().upload.setEnabled(true);
                } else {
                    JUpload.getInstance().upload.setEnabled(false);
                }
                JUpload.getInstance().stopButton.setEnabled(false);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void stopAllUploads() {
        Iterator iter = this.threadHistory.iterator();
        while (iter.hasNext()) {
            HTTPRequest element = (HTTPRequest)iter.next();
            if (!element.isRunning()) continue;
            element.stopUpload();
        }
        this.threadPool.clear();
    }
}

