/*
 * Decompiled with CFR 0.152.
 */
package JUpload.network;

import JUpload.network.Protocol;
import JUpload.network.jupSocketAddress;

public class HostConfiguration {
    private String m_strHost;
    private int m_iPort;
    private String m_strProtocol;
    private String m_strProxyHost;
    private int m_iProxyPort;
    private boolean m_fProxy = false;

    public void setHost(String t_strHost, int t_iPort, String t_strProtocol) {
        this.m_strHost = t_strHost;
        this.m_iPort = t_iPort;
        this.m_strProtocol = t_strProtocol;
    }

    public void setProxy(String t_strProxyHost, int t_iProxyPort) {
        this.m_strProxyHost = t_strProxyHost;
        this.m_iProxyPort = t_iProxyPort;
        this.m_fProxy = true;
    }

    public String getHost() {
        return this.m_strHost;
    }

    public String getProtocol() {
        return this.m_strProtocol.toLowerCase();
    }

    public jupSocketAddress getInetSocketAddress() {
        jupSocketAddress a_EndPoint = this.isProxy() ? new jupSocketAddress(this.getProxyHost(), this.getProxyPort()) : new jupSocketAddress(this.getHost(), this.getPort());
        return a_EndPoint;
    }

    private String getProxyHost() {
        if (!this.isProxy()) {
            return null;
        }
        return this.m_strProxyHost;
    }

    private int getProxyPort() {
        if (!this.isProxy()) {
            return -1;
        }
        return this.m_iProxyPort;
    }

    private boolean isProxy() {
        return this.m_fProxy;
    }

    private int getPort() {
        if (this.m_iPort == -1) {
            this.m_iPort = Protocol.getDefaultPortForProtocol(this.getProtocol());
        }
        return this.m_iPort;
    }
}

