<?php
/*
Plugin Name: Yahoo!&trade; Backlinks
Plugin URI: http://petercoughlin.com
Description: Shows your Yahoo!&trade; backlinks on the Dashboard.
Author: Peter Coughlin
Version: 1.1
Author URI: http://petercoughlin.com

Changelog
---------
1.1		Added dynamic news update.
1.0		Initial version.
*/

class yahoo_backlinks {
	function yahoo_backlinks() {		
		add_action('wp_dashboard_setup', array(&$this, 'widget_init'));
	}// end func
	
	function widget_init() {
		wp_add_dashboard_widget('ybl-dashboard-widget', 'Yahoo!&trade; Backlinks', array(&$this, 'widget_html'));
	}// end func
	
	function widget_html() {
		$url = get_bloginfo('url');
		if ( $_SERVER['HTTP_HOST'] == 'localhost' )
			$url = 'http://example.com';
		echo $this->get_yahoo_backlinks($url);
		echo $this->get_latest_news();
	}// end func

	function get_yahoo_backlinks($url) {
		$url = str_replace('http://', '', $url);
		$url = trim(str_replace('http', '', $url));
		$uri = 'http://siteexplorer.search.yahoo.com/search?p=http://'.$url.'&bwmo=d&bwm=i';
		$data = wp_remote_fopen($uri);
		$str = substr($data, strpos($data, '>Inlinks (')+10);
		$inlinks = substr($str, 0, strpos($str, ')'));
		if ( intval($inlinks) > 0 ) {
			$output = '<p>There are currently <strong>'.$inlinks.'</strong> <a href="http://siteexplorer.search.yahoo.com/search?p=http://'.$url.'&bwmo=d&bwm=i" target="_blank"><strong>Yahoo backlinks</strong></a> for <strong>http://'.$url.'</strong></p>';
			//preg_match_all('/<span\s*class="url">([^\<]+)<\/span>/i', $data, $matches);
			if ( preg_match_all('/<span\s*class="url">([^\<]+)<\/span>/i', $data, $matches) ) $results = $matches[1];
			if ( count($results) )
				$results = array_splice($results, 0, 10);
			if ( count($results) ) {
				$output .= '<div style="margin:0 -9px 10px;padding:10px;border:1px solid #ececec;border-width:1px 0;background:#f9f9f9"><ol style="margin-left:30px;">';
				foreach ( $results as $result )
					$output .= '<li><a href="'.$result.'" target="_blank">'.$result.'</a></li>';
				$output .= '</ol></div>';
			}// end if
		} else {
			$output = '<p>No Yahoo backlinks found for <strong>http://'.$url.'</strong></p>';
		}
		return $output;
	}

	function get_latest_news() {
		$url = 'http://wpeasyads.com/yahoo-backlinks-widget.php';
		$data = wp_remote_fopen($url);
		if ( $data !== false ) {
			$output = $data;
		} else {
			$output = '<p><strong>Like this tool?</strong> Then you will probably like <a href="http://wpeasyads.com" target="_blank"><strong>WP Easy Ads</strong></a>, the <a href="http://indexingtool.com" target="_blank"><strong>Indexing Tool</strong></a> and <a href="http://easycbads.com" target="_blank"><strong>Easy ClickBank Ads</strong></a> too!</p>';
		}
		return $output;
	}

}// end class
$yahoo_backlinks = new yahoo_backlinks;
