<?php 
/**
 Plugin Name: WP Robot 3
 Plugin URI: http://www.wprobot.net/
 Version: 3.40
 Description: Automatically post content related to any topic of your choice to your weblog.
 Author: WP Robot
 Author URI: http://www.wprobot.net/
 License: Commercial. For personal use only. Not to give away or resell
*/
/*  Copyright 2010 Lunatic Studios
*/
error_reporting(E_ERROR | E_PARSE);

if (version_compare(PHP_VERSION, '5.0.0.', '<'))
{
	die(__("WP Robot requires php 5 or a greater version to work.", "wprobot"));
}

if (!defined('WP_CONTENT_URL')) {
   define('WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
}

define('WPR_URLPATH', WP_PLUGIN_URL.'/'.plugin_basename( dirname(__FILE__) ).'/' );

function wpr_plugin_init () {
	$plugin_dir = basename(dirname(__FILE__));
	load_plugin_textdomain( 'wprobot', 'wp-content/plugins/' . $plugin_dir, $plugin_dir );
}
add_action ('init', 'wpr_plugin_init');

// Global Variables
$wpr_version = "3.40";
$wpr_table_campaigns = $wpdb->prefix . "wpr_campaigns";	
$wpr_table_templates = $wpdb->prefix . "wpr_templates";	
$wpr_table_posts = $wpdb->prefix . "wpr_posts";	
$wpr_table_errors = $wpdb->prefix . "wpr_errors";	
$wpr_modules = array("amazon","article","clickbank","ebay","flickr","yahooanswers","yahoonews","youtube","rss","translation","twitter","commissionjunction","oodle","pressrelease","shopzilla","itunes","linkshare","eventful","yelp","shareasale","avantlink");

@include_once("func.php");	
foreach ($wpr_modules as $module) {$inc = @include_once("modules/$module.php");if($inc == 1) {$wpr_loadedmodules[] = $module;}} // Modules

@include_once("wprupgrader.php");
@include_once("display-cl.php");

function wpr_default_options($update=0) {
	global $wpr_modules;

	@include_once("default-options.php");
	
	$options = unserialize(get_option("wpr_options"));	

		$options['wpr_poststatus'] = 'published';
		$options['wpr_autotag'] = 'Yes';
		$options['wpr_resetcount'] = 'no';
		$options['wpr_badwords'] = 'what;which;where;when;does;that;with;while;then;your;other;have;make;will';
		$options['wpr_randomize'] = 'yes';
		$options['wpr_randomize_comments'] = 'no';
		$options['wpr_help'] = 'Yes';
		$options['wpr_openlinks'] = 'no';
		$options['wpr_authorid'] = 1;
		$options['wpr_err_retries'] = 3;
		$options['wpr_err_maxerr'] = 2;
		$options['wpr_err_minmod'] = 1;
		$options['wpr_err_disable'] = 8;
		$options["wpr_global_exclude"] = "";
		$options['wpr_check_unique_old'] = "No";
		$options['wpr_rewrite_active'] = "No";
		$options['wpr_rewrite_email'] = "";
		$options['wpr_rewrite_key'] = "";
		$options['wpr_tbs_rewrite_email'] = "";
		$options['wpr_tbs_rewrite_pw'] = "";
		$options['wpr_tbs_spintxt'] = "No";
		$options['wpr_tbs_quality'] = 1;
		$options['wpr_rewrite_level'] = "r";
		$options['wpr_save_images'] = "No";
		foreach($wpr_modules as $module) {
			$function = "wpr_".$module."_options_default";
			if(function_exists($function)) {
				$moptions = $function();
				foreach($moptions as $moption => $default) {
					if(!empty($defaults[$moption])) {
						$options[$moption] = $defaults[$moption];
					} else {
						$options[$moption] = "$default";
					}
				}
			}
		}
		
		if(!empty($defaults['wpr_poststatus'])) {$options['wpr_poststatus'] = $defaults['wpr_poststatus'];}
		if(!empty($defaults['wpr_autotag'])) {$options['wpr_autotag'] = $defaults['wpr_autotag'];}
		if(!empty($defaults['wpr_resetcount'])) {$options['wpr_resetcount'] = $defaults['wpr_resetcount'];}
		if(!empty($defaults['wpr_badwords'])) {$options['wpr_badwords'] = $defaults['wpr_badwords'];}
		if(!empty($defaults['wpr_randomize'])) {$options['wpr_randomize'] = $defaults['wpr_randomize'];}
		if(!empty($defaults['wpr_randomize_comments'])) {$options['wpr_randomize_comments'] = $defaults['wpr_randomize_comments'];}
		if(!empty($defaults['wpr_openlinks'])) {$options['wpr_openlinks'] = $defaults['wpr_openlinks'];}
		if(!empty($defaults['wpr_authorid'])) {$options['wpr_authorid'] = $defaults['wpr_authorid'];}		
		
		if(WPLANG == "de_DE") {
			$options["wpr_aa_site"] = "de";
			$options["wpr_eb_country"] = "77";
			$options["wpr_eb_lang"] = "de";
			$options["wpr_yt_lang"] = "de";
			$options["wpr_yan_lang"] = "de";
			$options["wpr_yap_lang"] = "de";
			$options["wpr_twitter_lang"] = "de";
			$options['wpr_badwords'] = 'weil;doch;als;bei;nun;jetzt;nur;der;die;das;wir;ihr;sie;sobald;darauf';
			$options["wpr_aa_revtemplate"] = "<i>Rezession von {author} &uuml;ber {link}</i>&#13;<b>Bewertung: {rating}</b>&#13;{content}&#13;&#13;";
		}
		
		$croncode = substr(md5(time()), 0, 9);
		add_option('wpr_cron',$croncode);	
		add_option('wpr_cloak',"No");		
		
	if($update == 1) {
		update_option("wpr_options", serialize($options));	
		return $options;
	} else {
		add_option("wpr_options", serialize($options));	
	}
}

function wpr_default_options_single($module,$options) {
	//$options = unserialize(get_option("wpr_options"));	
	$function = "wpr_".$module."_options_default";
	if(function_exists($function)) {
		$moptions = $function();
		foreach($moptions as $moption => $default) {
			if(!empty($defaults[$moption])) {
				$options[$moption] = $defaults[$moption];
			} else {
				$options[$moption] = "$default";
			}
		}
	}
	//update_option("wpr_options", serialize($options));
	return $options;
}

function wpr_activate() {
   global $wpdb;
   
    $wpr_db_ver = 95;
	$wpr_table_campaigns = $wpdb->prefix . "wpr_campaigns";	
	$wpr_table_templates = $wpdb->prefix . "wpr_templates";	
	$wpr_table_posts = $wpdb->prefix . "wpr_posts";	
	$wpr_table_errors = $wpdb->prefix . "wpr_errors";		
   
	if(get_option('wpr_db_ver') != $wpr_db_ver) {

	if ( !empty($wpdb->charset) )
		$charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
	
    $sql[] = "CREATE TABLE ".$wpr_table_campaigns." (
        id BIGINT(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		name VARCHAR(255) NOT NULL,
		ctype VARCHAR(255) NOT NULL,
		keywords longtext NOT NULL,
		categories longtext NOT NULL,
		templates longtext NOT NULL,
		cinterval BIGINT(20) NOT NULL,
		period VARCHAR(255) NOT NULL,
		postspan VARCHAR(255) NOT NULL,
		replacekws longtext NOT NULL,
		excludekws longtext NOT NULL,
		amazon_department VARCHAR(255) NOT NULL,
		ebay_cat VARCHAR(255) NOT NULL,
		yahoo_cat VARCHAR(255) NOT NULL,
		translation VARCHAR(255) NOT NULL,
		customfield longtext NOT NULL,
		posts_created BIGINT(20) NOT NULL DEFAULT 0,
		pause INT(1) NOT NULL DEFAULT 0	
		) {$charset_collate};";
		
    $sql[] = "CREATE TABLE ".$wpr_table_templates." (
        id BIGINT(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		type VARCHAR(255) NOT NULL,
		typenum INT(4) NOT NULL DEFAULT 1,	
		content longtext NOT NULL,
		title longtext NOT NULL,
		comments_amazon INT(1) NOT NULL DEFAULT 0,
		comments_flickr INT(1) NOT NULL DEFAULT 0,
		comments_yahoo INT(1) NOT NULL DEFAULT 0,
		comments_youtube INT(1) NOT NULL DEFAULT 0,
		name VARCHAR(255) NOT NULL
		) {$charset_collate};";	

    $sql[] = "CREATE TABLE ".$wpr_table_posts." (
        id BIGINT(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		campaign BIGINT(20) NOT NULL,
		keyword VARCHAR(255) NOT NULL,		
		module VARCHAR(255) NOT NULL,
		unique_id longtext NOT NULL,
		time VARCHAR(255) NOT NULL
		) {$charset_collate};";		
		
    $sql[] = "CREATE TABLE ".$wpr_table_errors." (
        id BIGINT(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		campaign BIGINT(20) NOT NULL,
		keyword VARCHAR(255) NOT NULL,
		module VARCHAR(255) NOT NULL,	
		reason VARCHAR(255) NOT NULL,			
		message longtext NOT NULL,
		time VARCHAR(255) NOT NULL
		) {$charset_collate};";			

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);	
	
	update_option('wpr_db_ver',$wpr_db_ver);
	
	}			
}
