<?php
/*
* Add an RSS Aggregator
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/aggregator_model.php');

function wtg_add_aggregator() {
	if (isset($_POST['addAggregator'])) {
		check_admin_referer('add_aggregator');
		if (strlen(trim($_POST['name'])) >0 ) {
			$ag = new WTG_Aggregator();
			$ag->init();
			$id = $ag->add_aggregator(trim($_POST['name']), $_POST['enabled']);
			if ($id) {
				$url = 'admin.php?page=manage_aggregators';
				$url = add_query_arg('mode', 'edit', $url);
				$url = add_query_arg('id', $id, $url);
				$url = wp_nonce_url($url, 'manage_aggregators');
				echo '<div class="updated fade"><p>Aggregator added! Now you should edit the detailed information <a href="'.$url.'">here &raquo;</p></a></div>';
			}
		} else {
			echo '<div class="error"><p>Please input the website name of the aggregator.</p></div>';
		}
	}
?>
<div class="wrap">
	<h2>Add Aggregator</h2>
	<p>This screen is for future reference and will enable you to setup new aggregator web sites.</p>
	<form action="" method="post">
		<?php wp_nonce_field('add_aggregator'); ?>
		<p>
			<label>Website Name:</label>
			<input type="text" id="name" name="name" value="<?php echo isset($_POST['name'])?$_POST['name']:''; ?>" />
		</p>
		<p>
			<label>Status:</label>
			<select name="enabled">
				<option value="false" selected>disabled</option>
				<option value="true">enabled</option>
			</select>
		</p>
 		<p class="submit">
  			<input type="submit" name="addAggregator" value="Add Aggerator &raquo;" />
		</p>
	</form>
</div>
<?php
}