<?php
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/rss_database.php');

if(!class_exists('WTG_Rss_Log')):

class WTG_Rss_Log {
	var $wtg_db;
	var $session_id;
	var $log_level;
	var $buf;
	var $LEVEL_ERROR 	= 1;
	var $LEVEL_INFO		= 2;
	var $LEVEL_DEBUG 	= 3;


	function WTG_Rss_Log() {
		$this->wtg_db = new WTG_DB();
		$this->log_level = WTG_LOG_LEVEL;
	}


	function log($level, $session_id, $message){
		if ($level <= $this->log_level) {
			$this->wtg_db->add_log(
				array(
					'level' 		=> $level,
					'session_id' 	=> $session_id,
					'message' 		=> $this->buf . $message)
			);
		}
		$this->buf = '';
	}

	function error($message) {
		$this->log($this->LEVEL_ERROR, $this->session_id, $message);
	}

	function debug($message) {
		$this->log($this->LEVEL_DEBUG, $this->session_id, $message);
	}

	function info($message){
		$this->log($this->LEVEL_INFO, $this->session_id, $message);
	}

	function new_session_id() {
		return substr(md5(time()), 0, 8);
	}

	function buf($message) {
		$this->buf .= $message;
	}

	function get_session_id() {
		return $this->session_id;
	}

	function get_log_level() {
		return $this->log_level;
	}

	function set_log_level($log_level) {
		$this->log_level = $log_level;
	}

	function get_complete_log($len = 0) {
		return $this->wtg_db->find_all_log($len);
	}

	function get_complete_log_text($len = 0) {
		$logs = $this->get_complete_log($len);
		$out = '';
		foreach ($logs as $log) {
			$out .= ($log->time . ' ' . $log->message . "\n");
		}
		return $out;
	}

	function get_latest_log() {
		return $this->wtg_db->find_latest_log();
	}

	function get_latest_log_text() {
		$logs = $this->get_latest_log();
		$out = '';
		foreach ($logs as $log) {
			$out .= ($log->time . ' ' . $log->message . "\n");
		}
		return $out;
	}

	function get_log($session_id) {
		return $this->wtg_db->find_log_by_sessionid($session_id);
	}

	function openlog() {
		$this->session_id = $this->new_session_id();
	}

	function closelog() {
		$this->session_id = '';
	}
}

endif;


